## Assignment 1: Weather App

### Objective
The objective of this assignment is to create a web-based weather application that fetches and displays weather data for a user-specified city using HTML, CSS, and JavaScript. You will utilize DOM manipulation, DOM events, and the OpenWeatherMap API to achieve this.

### Deadline
The assignment is graded for **10 marks** and the deadline for submission is on **22nd September 2023 11:59pm**. Marks will be deducted for late submissions if any.

### Assignment Description

You are tasked with building a Weather App that allows users to check the current weather conditions for a city of their choice. Here are the key requirements:

1. **User Interface (UI):**
   - Create a user-friendly interface using HTML and CSS to input the city name and display the weather information.
   - Include an input field where users can enter the name of a city.
   - Implement a button to trigger the weather data retrieval.

2. **JavaScript Functionality:**
   - Use JavaScript for DOM manipulation and events to achieve the following:
     - When the user enters a city name and clicks the button, your JavaScript code should fetch weather data from the OpenWeatherMap API.
     - Display the weather information on the webpage, including temperature, weather description, humidity, and any other data you find relevant.
     - Ensure that the weather data updates when the user reloads the page.

3. **OpenWeatherMap API:**
   - Sign up for a free API key from the OpenWeatherMap website (https://openweathermap.org/api) to access weather data.
   - Use the Fetch API to make requests to the OpenWeatherMap API and retrieve the weather data for the specified city.

4. **Styling:**
   - Apply CSS to style the webpage and make it visually appealing.
   - Ensure that the design is responsive and looks good on both desktop and mobile devices.

### Submission
- Your project directory files must be added to the `Submissions/Assignment 1/[SRN]-NAME` folder in this repository. Fork this repository, add the files in the location and create a Pull Request to this repository.
- It is compulsory to include a screenshot of the webpage along with your submission.

### Grading Criteria
Your assignment will be graded based on the following criteria:

1. Correct use of HTML, CSS, and JavaScript:
   - Ensure that your HTML is well-structured.
   - Use CSS to style the UI effectively.
   - Implement JavaScript code for fetching and displaying weather data.

2. Creativity and Design:
   - Design a user-friendly and visually appealing interface.
   - Apply creativity in presenting weather information.

3. Functionality and Interactivity:
   - The app should correctly fetch and display weather data.
   - Ensure that the user interface is interactive and responsive to user actions.

4. Responsiveness and Usability:
   - Make sure the Weather App works well on various devices and screen sizes.

5. Code Quality and Organization:
   - Write clean and well-organized code.
   - Use meaningful variable and function names.
   - Comment your code to explain complex logic.

### Note
Stick to building the Weather App with vanilla HTML, CSS, and JavaScript. Do not use any other frameworks or libraries. Ensure that the weather data is fetched live and updated upon page reload. Properly handle any errors that may occur during data retrieval from the API.

Good luck!
